/* Night Time Alarm v2
 * ------------------ 
 *
 * Senses the light in a room and turns on a red light emitting diode(LED)  
 * and makes a sound with a piezo buzzer when the light drops below a certain point. 
 *
 */

int LDR = A0;       // select the input pin for the LDR
int ledRed = 12;    // select the pin for the Red LED
int ledGreen = 13;  // select the pin for the Green LED
int val = 0;        // variable to store the value coming from the sensor

void setup() {
  Serial.begin(9600);
  pinMode(LDR, INPUT);        // declare the LDR as an INPUT
  pinMode(ledRed, OUTPUT);    // declare the ledPin as an OUTPUT
  pinMode(ledGreen, OUTPUT);  // declare the ledPin as an OUTPUT
  pinMode(9, OUTPUT);         // declare pin 9 an output for the piezo buzzer
 }

void loop() {
{
  val = analogRead(LDR);       // read the value from the sensor
 Serial.println(val);

  if ( val > 1000 )   // If the light sensor stays above 1000 ...
  {
    digitalWrite( ledRed, LOW );      // turn this LED off 
    digitalWrite( ledGreen, HIGH );   // turn this LED on 
    analogWrite(9, 0);                // Turns off the piezo
    delay(200);
  }

  if ( val < 1000 )   // If the light sensor drops below 1000 ...
  {
    digitalWrite( ledRed, HIGH );    // turn this LED on
    digitalWrite( ledGreen, LOW );   // turn this LED off
    analogWrite(9, 200);             // This makes the piezo make noise. Change the number to something between 0 and 255
    delay(200);
   }
  }
}
